/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.blockentity;

import cloud.lemonslice.teastory.client.container.StoneMillContainer;
import cloud.lemonslice.teastory.recipe.stone_mill.StoneMillRecipe;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import xueluoanping.teastory.block.entity.NormalContainerBlockEntity;
import xueluoanping.teastory.block.entity.SyncedBlockEntity;
import xueluoanping.teastory.craft.BlockEntityRecipeWrapper;
import xueluoanping.teastory.registry.BlockEntityRegister;
import xueluoanping.teastory.registry.RecipeRegister;

public class StoneMillBlockEntity
extends NormalContainerBlockEntity {
    private int angel = 0;
    private boolean isWorking = false;
    private int processTicks = 0;
    private StoneMillRecipe currentRecipe;
    private final ItemStackHandler inputInventory = new SyncedBlockEntity.SyncedItemStackHandler(this);
    private final ItemStackHandler outputInventory = new SyncedBlockEntity.SyncedItemStackHandler(this, 3);
    private final FluidTank fluidTank = new SyncedBlockEntity.SyncedFluidTank(this, 2000);
    private final FluidTank inFluidTank = new SyncedBlockEntity.SyncedFluidTank(this, 2000);

    public StoneMillBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegister.STONE_MILL_TYPE.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inputInventory.deserializeNBT(nbt.m_128469_("InputInventory"));
        this.outputInventory.deserializeNBT(nbt.m_128469_("OutputInventory"));
        this.fluidTank.readFromNBT(nbt.m_128469_("FluidTank"));
        this.inFluidTank.readFromNBT(nbt.m_128469_("InputFluidTank"));
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128365_("InputInventory", (Tag)this.inputInventory.serializeNBT());
        compound.m_128365_("OutputInventory", (Tag)this.outputInventory.serializeNBT());
        compound.m_128365_("FluidTank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("InputFluidTank", (Tag)this.inFluidTank.writeToNBT(new CompoundTag()));
        compound.m_128405_("ProcessTicks", this.processTicks);
        super.m_183515_(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.m_58901_()) {
            if (ForgeCapabilities.ITEM_HANDLER.equals(cap)) {
                if (side == Direction.DOWN) {
                    return LazyOptional.of(() -> this.outputInventory).cast();
                }
                return LazyOptional.of(() -> this.inputInventory).cast();
            }
            if (ForgeCapabilities.FLUID_HANDLER.equals(cap)) {
                if (side == Direction.UP) {
                    return LazyOptional.of(() -> this.inFluidTank).cast();
                }
                return LazyOptional.of(this::getFluidTank).cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public FluidTank getInputFluidTank() {
        return this.inFluidTank;
    }

    public static void tick(Level worldIn, BlockPos pos, BlockState blockState, StoneMillBlockEntity stoneMillTileEntity) {
        if (worldIn == null || stoneMillTileEntity.m_58901_()) {
            return;
        }
        ItemStack input = stoneMillTileEntity.inputInventory.getStackInSlot(0);
        if (input.m_41619_()) {
            stoneMillTileEntity.setProcessTicks(0);
            stoneMillTileEntity.currentRecipe = null;
            return;
        }
        BlockEntityRecipeWrapper warp = new BlockEntityRecipeWrapper((IItemHandlerModifiable)stoneMillTileEntity.inputInventory, stoneMillTileEntity);
        if (stoneMillTileEntity.currentRecipe == null || !stoneMillTileEntity.currentRecipe.matches(warp, worldIn)) {
            stoneMillTileEntity.currentRecipe = worldIn.m_7465_().m_44015_((RecipeType)RecipeRegister.STONE_MILL.get(), (Container)warp, worldIn).orElse(null);
        }
        if (stoneMillTileEntity.currentRecipe != null) {
            stoneMillTileEntity.angel += 3;
            stoneMillTileEntity.angel %= 360;
            boolean flag = true;
            for (ItemStack out : stoneMillTileEntity.currentRecipe.getOutputItems()) {
                if (ItemHandlerHelper.insertItem((IItemHandler)stoneMillTileEntity.outputInventory, (ItemStack)out.m_41777_(), (boolean)true).m_41619_()) continue;
                flag = false;
            }
            if (flag && ++stoneMillTileEntity.processTicks >= stoneMillTileEntity.currentRecipe.getWorkTime()) {
                for (ItemStack out : stoneMillTileEntity.currentRecipe.getOutputItems()) {
                    ItemHandlerHelper.insertItem((IItemHandler)stoneMillTileEntity.outputInventory, (ItemStack)out.m_41777_(), (boolean)false);
                }
                stoneMillTileEntity.inputInventory.extractItem(0, 1, false);
                if (!stoneMillTileEntity.currentRecipe.getOutputFluid().isEmpty()) {
                    FluidStack fluidStacks = stoneMillTileEntity.currentRecipe.getOutputFluid();
                    if (stoneMillTileEntity.fluidTank.isEmpty() || stoneMillTileEntity.fluidTank.getFluid().getFluid() == fluidStacks.getFluid()) {
                        stoneMillTileEntity.fluidTank.fill(fluidStacks, IFluidHandler.FluidAction.EXECUTE);
                        stoneMillTileEntity.inFluidTank.drain(stoneMillTileEntity.currentRecipe.getInputFluidStack(), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                if (!stoneMillTileEntity.currentRecipe.getOutputFluid().isEmpty()) {
                    FluidUtil.getFluidHandler((Level)worldIn, (BlockPos)pos.m_7495_().m_121945_((Direction)stoneMillTileEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)), (Direction)Direction.UP).ifPresent(handler -> handler.fill(stoneMillTileEntity.currentRecipe.getOutputFluid(), IFluidHandler.FluidAction.EXECUTE));
                }
                stoneMillTileEntity.processTicks = 0;
            }
        } else {
            stoneMillTileEntity.setProcessTicks(0);
        }
    }

    public Fluid getOutputFluid() {
        if (this.currentRecipe != null) {
            return this.currentRecipe.getOutputFluid().getFluid();
        }
        return Fluids.f_76191_;
    }

    private void setProcessTicks(int ticks) {
        if (ticks != this.processTicks) {
            this.processTicks = ticks;
            this.inventoryChanged();
        }
    }

    public boolean isCompleted() {
        return this.currentRecipe == null;
    }

    public int getAngel() {
        return this.angel;
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public int getProcessTicks() {
        return this.processTicks;
    }

    public StoneMillRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player p_39956_) {
        return new StoneMillContainer(id, playerInventory, this.f_58858_, this.f_58857_);
    }
}

